/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;

public class TableItem extends Item {
	Table parent;
	Image [] images;
	String [] strings;
	boolean checked, grayed, cached; 

public TableItem (Table parent, int style) {
	super (parent, style);
	this.parent = parent;
	parent.createItem (this, parent.getItemCount ());
}

public TableItem (Table parent, int style, int index) {
	super (parent, style);
	this.parent = parent;
	parent.createItem (this, index);
}

protected void checkSubclass () {
	if (!isValidSubclass ()) error (SWT.ERROR_INVALID_SUBCLASS);
}

void clear () {
	text = "";
	image = null;
	strings = null;
	images = null;
	checked = grayed = cached = false;
//	foreground = background = null;
//	cellForeground = cellBackground = null;
//	font = null;
//	cellFont = null;
//	width = -1;
}

void destroyWidget () {
	parent.destroyItem (this);
	releaseHandle ();
}

public Color getBackground () {
	return parent.getBackground();
}

public Color getBackground (int index) {
	return getBackground();
}

public Rectangle getBounds () {
	return null;
}

public Rectangle getBounds (int index) {
	return null;
}

public boolean getChecked () {
	checkWidget();
	return checked;
}

public Font getFont () {
	return parent.getFont();
}

public Font getFont (int index) {
	return getFont();
}

public Color getForeground () {
	return parent.getForeground();
}

public Color getForeground (int index) {
	return getForeground();
}

public boolean getGrayed () {
	return false;
}

public Image getImage () {
	checkWidget();
	if (!parent.checkData (this)) error (SWT.ERROR_WIDGET_DISPOSED);
	return super.getImage ();
}

public Image getImage (int index) {
	checkWidget();
	if (!parent.checkData (this)) error (SWT.ERROR_WIDGET_DISPOSED);
	if (index == 0) return getImage ();
	if (images != null) {
		if (0 <= index && index < images.length) return images [index];
	}
	return null;
}

public Rectangle getImageBounds (int index) {
	return null;
}

public int getImageIndent () {
	return 0;
}

public Table getParent () {
	checkWidget ();
	return parent;
}

public String getText () {
	checkWidget ();
	if (!parent.checkData (this)) error (SWT.ERROR_WIDGET_DISPOSED);
	return super.getText ();
}

public String getText (int index) {
	checkWidget ();
	if (!parent.checkData (this)) error (SWT.ERROR_WIDGET_DISPOSED);
	if (index == 0) return getText ();
	if (strings != null) {
		if (0 <= index && index < strings.length) {
			String string = strings [index];
			return string != null ? string : "";
		}
	}
	return "";
}

public Rectangle getTextBounds (int index) {
	return null;
}

void releaseHandle () {
	super.releaseHandle ();
	object = null;
	parent = null;
}

void releaseWidget () {
	super.releaseWidget ();
	strings = null;
	images = null;
}

public void setBackground (Color color) {
}

public void setBackground (int index, Color color) {
}

public void setChecked (boolean checked) {
	checkWidget ();
	if ((parent.style & SWT.CHECK) == 0) return;
	if (this.checked == checked) return;
	this.checked = checked;
	cached = true;
	parent.invalidateItem (this, 0);
}

public void setFont (Font font) {
}

public void setFont (int index, Font font) {
}

public void setForeground (Color color) {
}

public void setForeground (int index, Color color) {
}

public void setGrayed (boolean grayed) {
}

public void setImage (Image[] images) {
	checkWidget();
	if (images == null) error (SWT.ERROR_NULL_ARGUMENT);
	for (int i=0; i<images.length; i++) {
		setImage (i, images [i]);
	}
}

public void setImage (int index, Image image) {
	checkWidget();
	if (image != null && image.isDisposed ()) {
		error(SWT.ERROR_INVALID_ARGUMENT);
	}
	int itemIndex = parent.indexOf (this);
	if (itemIndex == -1) return;
//	if (parent.imageBounds == null && image != null) {
//		parent.setItemHeight (image);
//	}
	if (index == 0)  {
		if (image != null && image.type == SWT.ICON) {
			if (image.equals (this.image)) return;
		}
//		width = -1;
		super.setImage (image);
	}
	int count = Math.max (1, parent.getColumnCount());
	if (0 <= index && index < count) {
		if (images == null) images = new Image [count];
		if (image != null && image.type == SWT.ICON) {
			if (image.equals (images [index])) return;
		}
		images [index] = image;	
	}
	cached = true;
	parent.invalidateItem (this, index);
//	if (index == 0) parent.setScrollWidth (this);
//	redraw (OS.kDataBrowserNoItem);
}

public void setImage (Image image) {
	checkWidget ();
	setImage (0, image);
}

public void setImageIndent (int indent) {
	checkWidget();
	if (indent < 0) return;
	cached = true;
}

public void setText (String[] strings) {
	checkWidget();
	if (strings == null) error (SWT.ERROR_NULL_ARGUMENT);
	for (int i=0; i<strings.length; i++) {
		String string = strings [i];
		if (string != null) setText (i, string);
	}
}

public void setText (int index, String string) {
	checkWidget();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (index == 0) {
		if (string.equals (text)) return;
//		width = -1;
		super.setText (string);
	}
	int count = Math.max (1, parent.getColumnCount());
	if (0 <= index && index < count) {
		if (strings == null) strings = new String [count];
		if (string.equals (strings [index])) return;
		strings [index] = string;
	}
	cached = true;
	parent.invalidateItem (this, index);
//	if (index == 0) parent.setScrollWidth (this);
//	redraw (OS.kDataBrowserNoItem);
}

public void setText (String string) {
	checkWidget();
	setText (0, string);
}

}
